/*
Blue Flash 30.05.2010

USB Template to demonstrate the functionality of the WELEC USB
interface. 

Some bytes are sent to the DSO which responds with some other bytes.
The result can be monitored with the RS232 terminal output of the DSO
and on the console window of this program.

The libusb.dev package has to be installed to get the header for the compiler.
No low level driver is needed!
*/

#include <stdio.h>
#include <errno.h>
#include <usb.h>


#define TimeOut 2000 // ms

#define USB_VendorID  0x4242 	//WELEC
#define USB_ProductID 0x0200 	//DSO

#define USB_Command_Block_Size 8
#define USB_Data_Block_Size   64

#define USB_End_Point_TX 0x01
#define USB_End_Point_RX 0x81

//###########################################################################################################################################

static struct usb_device
*UsbFindDevice(void)
{
  struct usb_bus *bus;
  struct usb_device *dev;
  usb_init();
  usb_find_busses();
  usb_find_devices();
  for (bus = usb_busses; bus; bus = bus->next)
  {
    for (dev = bus->devices; dev; dev = dev->next)
    {

      printf("found Vendor ID %X   Product id %X on Bus %d\n\r", dev->descriptor.idVendor, dev->descriptor.idProduct, bus->next);
      if ((dev->descriptor.idVendor == USB_VendorID) && (dev->descriptor.idProduct == USB_ProductID))
      { puts("WELEC DSO found"); return dev;}
    }
  }
  return NULL;
}

//###########################################################################################################################################
//BF special workaround functon for claiming
usb_dev_handle * open_and_claim(struct usb_device *dev, int interface)
{

	usb_dev_handle *dh;
	int res;

	dh = usb_open(dev);
	if (dh == NULL)
	{
		puts("USB device handle not found!");
		exit(EXIT_FAILURE);
	}

	#if defined(LIBUSB_HAS_GET_DRIVER_NP)
	#if defined(LIBUSB_HAS_DETACH_KERNEL_DRIVER_NP)
	char *name[256];
	if (usb_get_driver_np(dh, interface, (char *) name, sizeof(name)) == 0)
	{
		if (usb_detach_kernel_driver_np(dh, interface) < 0)
		{
			printf("%s\n", usb_strerror());
			return NULL;
		}
		usb_set_altinterface(dh, interface);
	}
	#endif
	#endif
	
	res = usb_claim_interface(dh, interface);
	if (res < 0)
	{
		puts("Can not claim interface!");

		//printf("Return Code is %d \n\r", return_code);

		if (res == -EBUSY)	//-16
		puts("Device is busy!");

		if (res == -ENOMEM)	//-12
		puts("Insufficient Memory!");

		usb_close(dh); 
		exit(EXIT_FAILURE);
	}


	return dh;
}


//###########################################################################################################################################
int
main(void)
{
	struct usb_device *dev;
	struct usb_dev_handle *handle;

	int return_code;

	char txbytes[USB_Data_Block_Size];
	char rxbytes[USB_Data_Block_Size];


    	/* Config USB trace debug, 0: None, 1-255: Trace depth */ 
   	//usb_set_debug( 50 );


	//scan for WELEC DSO
	dev = UsbFindDevice();
	if (dev == NULL)
	{
		puts("No WELEC DSO found!");
		exit(EXIT_FAILURE);
	}


	//open USB device
	handle = usb_open(dev);
	if (handle == NULL)
	{
		puts("USB device handle not found!");
		exit(EXIT_FAILURE);
	}


	usb_reset(handle);

	usb_close(handle); 

/*
	//scan for WELEC DSO again
	dev = UsbFindDevice();
	if (dev == NULL)
	{
		puts("No WELEC DSO found!");
		exit(EXIT_FAILURE);
	}
*/

/*
	handle = usb_open(dev);
	if (handle == NULL)
	{
		puts("USB device handle not found!");
		exit(EXIT_FAILURE);
	}
*/
/*
	//send bus request
	return_code = usb_claim_interface(handle, 0);
	if (return_code < 0)
	{
		puts("Can not claim interface!");

		//printf("Return Code is %d \n\r", return_code);

		if (return_code == -EBUSY)	//-16
		puts("Device is busy!");

		if (return_code == -ENOMEM)	//-12
		puts("Insufficient Memory!");

		//usb_reset(handle);

		usb_close(handle); 
		exit(EXIT_FAILURE);
	}
*/

	//send alternative bus request with workaround function
	handle = open_and_claim(dev, 0);



	//--------------------------------------------
	//             send data to dso
	//--------------------------------------------

	//write something into the buffer
	char x;
	for(x=0;x<USB_Data_Block_Size;x++)
	txbytes[x] = x;


	txbytes[0] = USB_Data_Block_Size; //first byte contains block size


	puts("Sending...");
	return_code = usb_interrupt_write(handle, USB_End_Point_TX, &txbytes[0], USB_Data_Block_Size, TimeOut);
	//return_code = usb_bulk_write(handle, USB_End_Point_TX, &txbytes[0], USB_Data_Block_Size, TimeOut);
	if (return_code < 1)
	puts("Send Error");
	else
	printf("%d bytes transferred to DSO\n\r",return_code);


	//--------------------------------------------
	//          receive data from dso
	//--------------------------------------------

	puts("Receiving...");

	// clear buffer
	for(x=0;x<USB_Data_Block_Size;x++)
	rxbytes[x] = 0;

// BF not needed
//	if (usb_control_msg(handle, USB_VendorRequestCode, 1, 1, USB_Data_Block_Size, NULL, 0, TimeOut) < 0)
//   	puts("USB_control_msg error!"); // should never occur


	return_code = usb_interrupt_read(handle, USB_End_Point_RX, &rxbytes[0], USB_Data_Block_Size, TimeOut);
	if (return_code < 1)
	puts("Read Error");
	else
	printf("%d bytes received from DSO\n\r",return_code);


	for(x=0;x<64;x++)
	{
		if (x%8==0)printf("\n\r");
		printf(" %x(%d) ", rxbytes[x], rxbytes[x]);
	}
	printf("\n\r");


	//--------------------------------------------
	// end of transmission
	//--------------------------------------------

	usb_release_interface(handle, 0);	//free the bus
  	usb_close(handle);
  	exit(EXIT_SUCCESS);
}
